import React, {Component} from 'react';
import PropTypes from 'prop-types';
import Select from "../Select/Select";
import {graphql, compose} from "react-apollo";
import {condizioniMeteosQuery} from "../../../../api/queries";
import {Card, CardBody, CardText} from "reactstrap";
import BlinkDot from "../../../Loading/BlinkDot";

class MeteoSelect extends Component {

    constructor(props) {
        super(props);
    }

    render() {
        if(this.props.data.loading) {
            return(<Card>
                <CardBody>
                    <CardText className="text-info">
                        Caricamento in corso{' '}
                        <BlinkDot/>
                        <BlinkDot/>
                        <BlinkDot/>
                    </CardText>
                </CardBody>
            </Card>);
        }

        return (<Select
            {...this.props}
            options={this.props.data.condizioniMeteos.map(item => {
                return { value: item.id, label: item.etichetta, };
            })} />);
    }
}

export default compose(
    graphql(condizioniMeteosQuery),
)(MeteoSelect)

MeteoSelect.defaultProps = {};

MeteoSelect.propTypes = {};